const test = require("tape");
const { normalize, validate } = require("../lib/zenkakukana.js");

test("zenkakukana#normalize", function (t) {
  t.equal(normalize("ｱｲｳｴｵ"), "アイウエオ");
  t.equal(normalize("ｶｷｸｹｺ"), "カキクケコ");
  t.equal(normalize("ｻｼｽｾｿ"), "サシスセソ");
  t.equal(normalize("ﾀﾁﾂﾃﾄ"), "タチツテト");
  t.equal(normalize("ﾅﾆﾇﾈﾉ"), "ナニヌネノ");
  t.equal(normalize("ﾊﾋﾌﾍﾎ"), "ハヒフヘホ");
  t.equal(normalize("ﾏﾐﾑﾒﾓ"), "マミムメモ");
  t.equal(normalize("ﾔﾕﾖ"), "ヤユヨ");
  t.equal(normalize("ﾗﾘﾙﾚﾛ"), "ラリルレロ");
  t.equal(normalize("ﾜｦﾝ"), "ワヲン");
  t.equal(normalize("ｧｨｩｪｫｯｬｭｮ"), "ァィゥェォッャュョ");
  t.equal(normalize("ｶﾞｷﾞｸﾞｹﾞｺﾞ"), "ガギグゲゴ");
  t.equal(normalize("ｻﾞｼﾞｽﾞｾﾞｿﾞ"), "ザジズゼゾ");
  t.equal(normalize("ﾀﾞﾁﾞﾂﾞﾃﾞﾄﾞ"), "ダヂヅデド");
  t.equal(normalize("ﾊﾞﾋﾞﾌﾞﾍﾞﾎﾞ"), "バビブベボ");
  t.equal(normalize("ﾊﾟﾋﾟﾌﾟﾍﾟﾎﾟ"), "パピプペポ");
  t.equal(normalize("ｳﾞ"), "ヴ");
  t.equal(normalize("ｰ"), "ー");
  //t.equal(normalize("･"), "・");
  //t.equal(normalize("｡"), "。");
  //t.equal(normalize("､"), "、");
  //t.equal(normalize("｢"), "「");
  //t.equal(normalize("｣"), "」");
  t.equal(normalize("カ\u3099キ\u3099ク\u3099ケ\u3099コ\u3099"), "ガギグゲゴ");
  t.equal(normalize("サ\u3099シ\u3099ス\u3099セ\u3099ソ\u3099"), "ザジズゼゾ");
  t.equal(normalize("タ\u3099チ\u3099ツ\u3099テ\u3099ト\u3099"), "ダヂヅデド");
  t.equal(normalize("ハ\u3099ヒ\u3099フ\u3099ヘ\u3099ホ\u3099"), "バビブベボ");
  t.equal(normalize("ハ\u309aヒ\u309aフ\u309aヘ\u309aホ\u309a"), "パピプペポ");
  t.equal(normalize("ウ\u3099"), "ヴ");
  t.equal(normalize("ｶ\u3099ｷ\u3099ｸ\u3099ｹ\u3099ｺ\u3099"), "ガギグゲゴ");
  t.equal(normalize("ｻ\u3099ｼ\u3099ｽ\u3099ｾ\u3099ｿ\u3099"), "ザジズゼゾ");
  t.equal(normalize("ﾀ\u3099ﾁ\u3099ﾂ\u3099ﾃ\u3099ﾄ\u3099"), "ダヂヅデド");
  t.equal(normalize("ﾊ\u3099ﾋ\u3099ﾌ\u3099ﾍ\u3099ﾎ\u3099"), "バビブベボ");
  t.equal(normalize("ﾊ\u309aﾋ\u309aﾌ\u309aﾍ\u309aﾎ\u309a"), "パピプペポ");
  t.equal(normalize("ｳ\u3099"), "ヴ");
  t.equal(normalize("あいうえお"), "アイウエオ");
  t.equal(normalize("かきくけこ"), "カキクケコ");
  t.equal(normalize("さしすせそ"), "サシスセソ");
  t.equal(normalize("たちつてと"), "タチツテト");
  t.equal(normalize("なにぬねの"), "ナニヌネノ");
  t.equal(normalize("はひふへほ"), "ハヒフヘホ");
  t.equal(normalize("まみむめも"), "マミムメモ");
  t.equal(normalize("やゆよ"), "ヤユヨ");
  t.equal(normalize("らりるれろ"), "ラリルレロ");
  t.equal(normalize("わをん"), "ワヲン");
  t.equal(normalize("ぁぃぅぇぉっゃゅょ"), "ァィゥェォッャュョ");
  t.equal(normalize("がぎぐげご"), "ガギグゲゴ");
  t.equal(normalize("ざじずぜぞ"), "ザジズゼゾ");
  t.equal(normalize("だぢづでど"), "ダヂヅデド");
  t.equal(normalize("ばびぶべぼ"), "バビブベボ");
  t.equal(normalize("ぱぴぷぺぽ"), "パピプペポ");
  t.equal(normalize("ゔ"), "ヴ");

  t.equal(normalize("漢字"), "漢字");
  t.equal(normalize(0), 0);
  t.equal(normalize(null), null);
  t.equal(normalize(true), true);
  t.end();
});

test("zenkakukana#validate", function (t) {
  t.doesNotThrow(() => validate("アイウエオ"));
  t.throws(() => validate(0));
  t.throws(() => validate("あいうえお"));
  t.throws(() => validate("あイウエお"));
  t.throws(() => validate("12345"));
  t.end();
});
