const test = require("tape");
const { normalize, validate } = require("../lib/pcd/SexCodeList.js");

test("pcd/SexCodeList#normalize", function (t) {
  t.equal(normalize("0"), "0");
  t.equal(normalize("1"), "1");
  t.equal(normalize("2"), "2");
  t.equal(normalize("9"), "9");
  t.equal(normalize(0), "0");
  t.equal(normalize(1), "1");
  t.equal(normalize(2), "2");
  t.equal(normalize(9), "9");
  t.equal(normalize("０"), "0");
  t.equal(normalize("１"), "1");
  t.equal(normalize("２"), "2");
  t.equal(normalize("９"), "9");
  t.equal(normalize("0(不明)"), "0");
  t.equal(normalize("1(男性)"), "1");
  t.equal(normalize("2(女性)"), "2");
  t.equal(normalize("9(その他)"), "9");
  // 正規化ができない場合はソース文字列を返す
  t.equal(normalize(3), 3);
  t.equal(normalize(null), null);
  t.equal(normalize("不明"), "不明");
  t.equal(normalize("男性"), "男性");
  t.equal(normalize("女性"), "女性");
  t.equal(normalize("その他"), "その他");
  t.end();
});

test("pcd/SexCodeList#validate", function (t) {
  t.doesNotThrow(() => validate("0"));
  t.doesNotThrow(() => validate("1"));
  t.doesNotThrow(() => validate("2"));
  t.doesNotThrow(() => validate("9"));
  t.throws(() => validate("3"));
  t.throws(() => validate(0));
  t.throws(() => validate(1));
  t.throws(() => validate(2));
  t.throws(() => validate(9));
  t.throws(() => validate("０"));
  t.throws(() => validate("１"));
  t.throws(() => validate("２"));
  t.throws(() => validate("９"));
  t.throws(() => validate("不明"));
  t.throws(() => validate("男性"));
  t.throws(() => validate("女性"));
  t.throws(() => validate("その他"));
  t.end();
});
