const test = require("tape");
const { normalize, validate } = require("../lib/pcd/MaritalStatusCodeList.js");

test("pcd/MaritalStatusCodeList#normalize", function (t) {
  t.equal(normalize("0"), "0");
  t.equal(normalize("1"), "1");
  t.equal(normalize("2"), "2");
  t.equal(normalize("3"), "3");
  t.equal(normalize("4"), "4");
  t.equal(normalize("9"), "9");
  t.equal(normalize(0), "0");
  t.equal(normalize(1), "1");
  t.equal(normalize(2), "2");
  t.equal(normalize(3), "3");
  t.equal(normalize(4), "4");
  t.equal(normalize(9), "9");
  t.equal(normalize("０"), "0");
  t.equal(normalize("１"), "1");
  t.equal(normalize("２"), "2");
  t.equal(normalize("３"), "3");
  t.equal(normalize("４"), "4");
  t.equal(normalize("９"), "9");
  t.equal(normalize("0(不明)"), "0");
  t.equal(normalize("1(未婚)"), "1");
  t.equal(normalize("2(既婚(有配偶))"), "2");
  t.equal(normalize("3(既婚(死別))"), "3");
  t.equal(normalize("4(既婚(離別))"), "4");
  t.equal(normalize("9(その他)"), "9");
  // 正規化ができない場合はソース文字列を返す
  t.equal(normalize(5), 5);
  t.equal(normalize(null), null);
  t.equal(normalize("不明"), "不明");
  t.equal(normalize("その他"), "その他");
  t.end();
});

test("pcd/MaritalStatusCodeList#validate", function (t) {
  t.doesNotThrow(() => validate("0"));
  t.doesNotThrow(() => validate("1"));
  t.doesNotThrow(() => validate("2"));
  t.doesNotThrow(() => validate("3"));
  t.doesNotThrow(() => validate("4"));
  t.doesNotThrow(() => validate("9"));
  t.throws(() => validate("5"));
  t.throws(() => validate(0));
  t.throws(() => validate(1));
  t.throws(() => validate(2));
  t.throws(() => validate(3));
  t.throws(() => validate(4));
  t.throws(() => validate(9));
  t.throws(() => validate("０"));
  t.throws(() => validate("１"));
  t.throws(() => validate("２"));
  t.throws(() => validate("３"));
  t.throws(() => validate("４"));
  t.throws(() => validate("９"));
  t.throws(() => validate("不明"));
  t.throws(() => validate("その他"));
  t.end();
});
