const test = require("tape");
const { normalize, validate } = require("../lib/pcd/LegalEntityKindCodeList.js");

test("pcd/LegalEntityKindCodeList#normalize", function (t) {
  t.equal(normalize("101"), "101");
  t.equal(normalize("201"), "201");
  t.equal(normalize("301"), "301");
  t.equal(normalize("302"), "302");
  t.equal(normalize("303"), "303");
  t.equal(normalize("304"), "304");
  t.equal(normalize("305"), "305");
  t.equal(normalize("399"), "399");
  t.equal(normalize("401"), "401");
  t.equal(normalize("499"), "499");
  t.equal(normalize(101), "101");
  t.equal(normalize(201), "201");
  t.equal(normalize(301), "301");
  t.equal(normalize(302), "302");
  t.equal(normalize(303), "303");
  t.equal(normalize(304), "304");
  t.equal(normalize(305), "305");
  t.equal(normalize(399), "399");
  t.equal(normalize(401), "401");
  t.equal(normalize(499), "499");
  t.equal(normalize("１０１"), "101");
  t.equal(normalize("２０１"), "201");
  t.equal(normalize("３０１"), "301");
  t.equal(normalize("３０２"), "302");
  t.equal(normalize("３０３"), "303");
  t.equal(normalize("３０４"), "304");
  t.equal(normalize("３０５"), "305");
  t.equal(normalize("３９９"), "399");
  t.equal(normalize("４０１"), "401");
  t.equal(normalize("４９９"), "499");
  t.equal(normalize("101:国の機関"), "101");
  t.equal(normalize("201:地方公共団体"), "201");
  t.equal(normalize("301:株式会社"), "301");
  t.equal(normalize("302:有限会社"), "302");
  t.equal(normalize("303:合名会社"), "303");
  t.equal(normalize("304:合資会社"), "304");
  t.equal(normalize("305:合同会社"), "305");
  t.equal(normalize("399:その他の設立登記法人"), "399");
  t.equal(normalize("401:外国会社等"), "401");
  t.equal(normalize("499:その他"), "499");
  // 正規化ができない場合はソース文字列を返す
  t.equal(normalize(999), 999);
  t.equal(normalize(null), null);
  t.equal(normalize("不明"), "不明");
  t.equal(normalize("その他"), "その他");
  t.end();
});

test("pcd/LegalEntityKindCodeList#validate", function (t) {
  t.doesNotThrow(() => validate("101"));
  t.doesNotThrow(() => validate("201"));
  t.doesNotThrow(() => validate("301"));
  t.doesNotThrow(() => validate("302"));
  t.doesNotThrow(() => validate("303"));
  t.doesNotThrow(() => validate("304"));
  t.doesNotThrow(() => validate("305"));
  t.doesNotThrow(() => validate("399"));
  t.doesNotThrow(() => validate("401"));
  t.doesNotThrow(() => validate("499"));
  t.throws(() => validate("999"), "存在しないコード");
  t.throws(() => validate(101));
  t.throws(() => validate(201));
  t.throws(() => validate(301));
  t.throws(() => validate(302));
  t.throws(() => validate(303));
  t.throws(() => validate(304));
  t.throws(() => validate(305));
  t.throws(() => validate(399));
  t.throws(() => validate(401));
  t.throws(() => validate(499));
  t.throws(() => validate("１０１"));
  t.throws(() => validate("２０１"));
  t.throws(() => validate("３０１"));
  t.throws(() => validate("３０２"));
  t.throws(() => validate("３０３"));
  t.throws(() => validate("３０４"));
  t.throws(() => validate("３０５"));
  t.throws(() => validate("３９９"));
  t.throws(() => validate("４０１"));
  t.throws(() => validate("４９９"));
  t.throws(() => validate("国の機関"));
  t.throws(() => validate("その他"));
  t.end();
});
