const test = require("tape");
const { normalize, validate } = require("../lib/pcd/CountryCodeList.js");

test("pcd/CountryCodeList#normalize", function (t) {
  t.equal(normalize("JPN"), "JPN");
  t.equal(normalize("USA"), "USA");
  t.equal(normalize("XXX"), "XXX");
  t.equal(normalize("jpn"), "JPN");
  t.equal(normalize("usa"), "USA");
  t.equal(normalize("xxx"), "XXX");
  t.equal(normalize("ＪＰＮ"), "JPN");
  t.equal(normalize("ＵＳＡ"), "USA");
  t.equal(normalize("ＸＸＸ"), "XXX");
  t.equal(normalize("ｊｐｎ"), "JPN");
  t.equal(normalize("ｕｓａ"), "USA");
  t.equal(normalize("ｘｘｘ"), "XXX");
  t.equal(normalize("JP"), "JPN");
  t.equal(normalize("US"), "USA");
  t.equal(normalize("XX"), "XXX");
  t.equal(normalize("ＪＰ"), "JPN");
  t.equal(normalize("ＵＳ"), "USA");
  t.equal(normalize("ＸＸ"), "XXX");
  t.equal(normalize("ｊｐ"), "JPN");
  t.equal(normalize("ｕｓ"), "USA");
  t.equal(normalize("ｘｘ"), "XXX");
  t.equal(normalize("JPN:日本"), "JPN");
  t.equal(normalize("USA:アメリカ合衆国"), "USA");
  t.equal(normalize("XXX:その他"), "XXX");
  // 正規化ができない場合はソース文字列を返す
  t.equal(normalize("ZZZ"), "ZZZ");
  t.equal(normalize("zzz"), "zzz");
  t.equal(normalize(999), 999);
  t.equal(normalize(null), null);
  t.equal(normalize("不明"), "不明");
  t.equal(normalize("その他"), "その他");
  t.end();
});

test("pcd/CountryCodeList#validate", function (t) {
  t.doesNotThrow(() => validate("JPN"));
  t.doesNotThrow(() => validate("USA"));
  t.doesNotThrow(() => validate("XXX"));
  t.throws(() => validate("ZZZ"), "存在しないコード");
  t.throws(() => validate("jpn"));
  t.throws(() => validate("usa"));
  t.throws(() => validate("xxx"));
  t.throws(() => validate("jp"));
  t.throws(() => validate("us"));
  t.throws(() => validate("xx"));
  t.throws(() => validate("ｊｐｎ"));
  t.throws(() => validate("ｕｓａ"));
  t.throws(() => validate("ｘｘｘ"));
  t.throws(() => validate("ｊｐ"));
  t.throws(() => validate("ｕｓ"));
  t.throws(() => validate("ｘｘ"));
  t.throws(() => validate("ＪＰＮ"));
  t.throws(() => validate("ＵＳＡ"));
  t.throws(() => validate("ＸＸＸ"));
  t.throws(() => validate("ＪＰ"));
  t.throws(() => validate("ＵＳ"));
  t.throws(() => validate("ＸＸ"));
  t.throws(() => validate(0));
  t.throws(() => validate("日本"));
  t.end();
});
