const test = require("tape");
const { normalize, validate } = require("../lib/pcd/ApplicabilityCodeList.js");

test("pcd/ApplicabilityCodeList#normalize", function (t) {
  t.equal(normalize("0"), "0");
  t.equal(normalize("1"), "1");
  t.equal(normalize("9"), "9");
  t.equal(normalize(0), "0");
  t.equal(normalize(1), "1");
  t.equal(normalize(9), "9");
  t.equal(normalize("０"), "0");
  t.equal(normalize("１"), "1");
  t.equal(normalize("９"), "9");
  t.equal(normalize("0(非該当)"), "0");
  t.equal(normalize("1(該当)"), "1");
  t.equal(normalize("9(不明)"), "9");
  // 正規化ができない場合はソース文字列を返す
  t.equal(normalize(2), 2);
  t.equal(normalize(null), null);
  t.equal(normalize("不明"), "不明");
  t.equal(normalize("非該当"), "非該当");
  t.equal(normalize("該当"), "該当");
  t.end();
});

test("pcd/ApplicabilityCodeList#validate", function (t) {
  t.doesNotThrow(() => validate("0"));
  t.doesNotThrow(() => validate("1"));
  t.doesNotThrow(() => validate("9"));
  t.throws(() => validate(0));
  t.throws(() => validate(1));
  t.throws(() => validate(9));
  t.throws(() => validate("０"));
  t.throws(() => validate("１"));
  t.throws(() => validate("９"));
  t.throws(() => validate("不明"));
  t.throws(() => validate("非該当"));
  t.throws(() => validate("該当"));
  t.end();
});
