const test = require("tape");
const { normalize, validate } = require("../lib/ex/zenkakuKana.js");

test("ex/zenkakuKana#normalize", function (t) {
  t.equal(normalize("カブシキガイシャジーアイエフ"), "カブシキガイシャジーアイエフ");
  t.equal(normalize("カブシキガイシャ ジーアイエフ"), "カブシキガイシャジーアイエフ");
  t.equal(normalize(" カブシキガイシャ ジーアイエフ "), "カブシキガイシャジーアイエフ");
  t.equal(normalize("ｶﾌﾞｼｷｶﾞｲｼｬｼﾞｰｱｲｴﾌ"), "カブシキガイシャジーアイエフ");
  t.equal(normalize("かぶしきがいしゃじーあいえふ"), "カブシキガイシャジーアイエフ");
  t.equal(
    normalize("カフ\u3099シキカ\u3099イシャシ\u3099ーアイエフ"),
    "カブシキガイシャジーアイエフ"
  );
  t.equal(
    normalize("かふ\u3099しきか\u3099いしゃし\u3099ーあいえふ"),
    "カブシキガイシャジーアイエフ"
  );
  t.equal(normalize("ｶﾌ\u3099ｼｷｶ\u3099ｲｼｬｼ\u3099ｰｱｲｴﾌ"), "カブシキガイシャジーアイエフ");
  t.equal(normalize(""), "");
  t.equal(normalize(0), 0);
  t.equal(normalize(null), null);
  t.equal(normalize(true), true);
  t.equal(normalize(false), false);
  t.end();
});

test("ex/zenkakuKana#validate", function (t) {
  t.doesNotThrow(() => validate("カブシキガイシャジーアイエフ"));
  t.doesNotThrow(() => validate(""));
  t.throws(() => validate(0));
  t.throws(() => validate("カブシキガイシャ ジーアイエフ"));
  t.throws(() => validate("ｶﾌﾞｼｷｶﾞｲｼｬｼﾞｰｱｲｴﾌ"));
  t.throws(() => validate("かぶしきがいしゃじーあいえふ"));
  t.throws(() => validate("カフ\u3099シキカ\u3099イシャシ\u3099ーアイエフ"));
  t.throws(() => validate("かふ\u3099しきか\u3099いしゃし\u3099ーあいえふ"));
  t.throws(() => validate("ｶﾌ\u3099ｼｷｶ\u3099ｲｼｬｼ\u3099ｰｱｲｴﾌ"));
  t.end();
});
