const test = require("tape");
const { normalize, validate } = require("../lib/ex/uri.js");

test("ex/uri#normalize", function (t) {
  t.equal(normalize("http://example.org/"), "http://example.org/", "http");
  t.equal(normalize("https://example.org/"), "https://example.org/", "https");
  t.equal(normalize("ｈｔｔｐ：／／ｅｘａｍｐｌｅ．ｏｒｇ／"), "http://example.org/", "http全角");
  t.equal(
    normalize("ｈｔｔｐｓ：／／ｅｘａｍｐｌｅ．ｏｒｇ／"),
    "https://example.org/",
    "https全角"
  );
  // 正規化ができない場合はソース文字列を返す
  t.equal(normalize(null), null);
  t.equal(normalize("不明"), "不明");
  t.end();
});

test("ex/uri#validate", function (t) {
  t.doesNotThrow(() => validate("http://example.org/"));
  t.doesNotThrow(() => validate("https://example.org/"));
  t.throws(() => validate(0));
  t.throws(() => validate(""));
  t.throws(() => validate("ｈｔｔｐ：／／ｅｘａｍｐｌｅ．ｏｒｇ／"));
  t.throws(() => validate("ｈｔｔｐｓ：／／ｅｘａｍｐｌｅ．ｏｒｇ／"));
  t.end();
});
