const test = require("tape");
const { normalize, validate } = require("../lib/ex/time.js");

test("ex/time#normalize", function (t) {
  t.equal(normalize("23:59"), "23:59", "正常系");
  t.equal(normalize("159"), "01:59", "コロン、接頭ゼロの省略");
  t.equal(normalize("1231"), "12:31", "コロン、接頭ゼロの省略");
  t.equal(normalize(101), "01:01", "整数(3桁)");
  t.equal(normalize(1231), "12:31", "整数(4桁)");
  t.equal(normalize("12時31分"), "12:31", "半角+漢字");
  t.equal(normalize("1時1分"), "01:01", "半角+漢字");
  t.equal(normalize("１２時３１分"), "12:31", "全角+漢字");
  t.equal(normalize("１時１分"), "01:01", "全角+漢字");
  t.equal(normalize("25-00"), "25-00", "無効な時");
  t.equal(normalize("00-60"), "00-60", "無効な分");
  // 正規化ができない場合はソース文字列を返す
  t.equal(normalize(null), null);
  t.equal(normalize("不明"), "不明");
  t.end();
});

test("ex/time#validate", function (t) {
  t.doesNotThrow(() => validate("23:59"));
  t.throws(() => validate(0));
  t.throws(() => validate(2359));
  t.throws(() => validate("２３：５９"));
  t.throws(() => validate("23時59分"));
  t.throws(() => validate("25-00"));
  t.throws(() => validate("00-60"));
  t.end();
});
