const test = require("tape");
const { normalize, validate } = require("../lib/ex/stringKana.js");

test("ex/stringKana#normalize", function (t) {
  t.equal(normalize("キオイレジデンス101"), "キオイレジデンス101");
  t.equal(normalize("キオイレジデンス 101"), "キオイレジデンス 101");
  t.equal(normalize("キオイレジデンス　101"), "キオイレジデンス 101");
  t.equal(normalize(0), "0");
  t.equal(normalize("きおいれじでんす101"), "キオイレジデンス101");
  t.equal(normalize("ｷｵｲﾚｼﾞﾃﾞﾝｽ101"), "キオイレジデンス101");
  t.equal(normalize("キオイレシ\u3099テ\u3099ンス101"), "キオイレジデンス101");
  t.equal(normalize("ｷｵｲﾚｼ\u3099ﾃ\u3099ﾝｽ101"), "キオイレジデンス101");
  t.equal(normalize(null), null);
  t.equal(normalize(true), true);
  t.equal(normalize(false), false);
  t.end();
});

test("ex/stringKana#validate", function (t) {
  t.doesNotThrow(() => validate("キオイレジデンス101"));
  t.throws(() => validate(0));
  t.throws(() => validate("きおいれじでんす101"));
  t.throws(() => validate("ｷｵｲﾚｼﾞﾃﾞﾝｽ101"));
  t.throws(() => validate("キオイレシ\u3099テ\u3099ンス101"));
  t.throws(() => validate("ｷｵｲﾚｼ\u3099ﾃ\u3099ﾝｽ101"));
  t.end();
});
