const test = require("tape");
const { normalize, validate } = require("../lib/ex/stringEn.js");

test("ex/stringEn#normalize", function (t) {
  t.equal(normalize("Kioi Green Space 2024"), "Kioi Green Space 2024");
  t.equal(normalize("Kioi　Green　Space　2024"), "Kioi Green Space 2024");
  t.equal(normalize("Ｋｉｏｉ　Ｇｒｅｅｎ　Ｓｐａｃｅ　２０２４"), "Kioi Green Space 2024");
  t.equal(normalize(0), "0");
  t.equal(normalize(null), null);
  t.equal(normalize(true), true);
  t.equal(normalize(false), false);
  t.end();
});

test("ex/stringEn#validate", function (t) {
  t.doesNotThrow(() => validate("Kioi Green Space 2024"));
  t.doesNotThrow(() => validate(""));
  t.throws(() => validate(0));
  t.throws(() => validate("Kioi　Green　Space　2024"));
  t.throws(() => validate("Ｋｉｏｉ　Ｇｒｅｅｎ　Ｓｐａｃｅ　２０２４"));
  t.end();
});
