const test = require("tape");
const { normalize, validate } = require("../lib/ex/string.js");

test("ex/string#normalize", function (t) {
  t.equal(normalize("abcdABCD1234!@#$%"), "abcdABCD1234!@#$%");
  t.equal(normalize("カ\u3099キ\u3099ク\u3099ケ\u3099コ\u3099"), "ガギグゲゴ");
  t.equal(normalize("サ\u3099シ\u3099ス\u3099セ\u3099ソ\u3099"), "ザジズゼゾ");
  t.equal(normalize("タ\u3099チ\u3099ツ\u3099テ\u3099ト\u3099"), "ダヂヅデド");
  t.equal(normalize("ハ\u3099ヒ\u3099フ\u3099ヘ\u3099ホ\u3099"), "バビブベボ");
  t.equal(normalize("ハ\u309aヒ\u309aフ\u309aヘ\u309aホ\u309a"), "パピプペポ");
  t.equal(normalize("ウ\u3099"), "ヴ");
  t.equal(normalize("ｶ\u3099ｷ\u3099ｸ\u3099ｹ\u3099ｺ\u3099"), "ガギグゲゴ");
  t.equal(normalize("ｻ\u3099ｼ\u3099ｽ\u3099ｾ\u3099ｿ\u3099"), "ザジズゼゾ");
  t.equal(normalize("ﾀ\u3099ﾁ\u3099ﾂ\u3099ﾃ\u3099ﾄ\u3099"), "ダヂヅデド");
  t.equal(normalize("ﾊ\u3099ﾋ\u3099ﾌ\u3099ﾍ\u3099ﾎ\u3099"), "バビブベボ");
  t.equal(normalize("ﾊ\u309aﾋ\u309aﾌ\u309aﾍ\u309aﾎ\u309a"), "パピプペポ");
  t.equal(normalize("ｳ\u3099"), "ヴ");
  t.equal(normalize(1234), "1234");
  t.equal(normalize(null), null);
  t.equal(normalize(true), true);
  t.equal(normalize(false), false);
  t.end();
});

test("ex/string#validate", function (t) {
  t.doesNotThrow(() => validate("abcdABCD1234!@#$%"));
  t.throws(() => validate(0));
  t.end();
});
