const test = require("tape");
const { normalize, validate } = require("../lib/ex/standardAreaCode.js");

test("ex/standardAreaCode#normalize", function (t) {
  t.equal(normalize("011002"), "011002", "正常系");
  t.equal(normalize("01100-2"), "011002", "区切り");
  t.equal(normalize("０１１００２"), "011002", "全角");
  t.equal(normalize("011002:札幌市"), "011002", "余計な文字列");
  t.equal(normalize(11002), "011002", "数値");

  //t.equal(normalize("11002"), "011002", "先頭のゼロがない");
  t.equal(normalize("01100"), "011002", "チェックデジットの補完");

  t.equal(normalize("011003"), "011003", "チェックデジットエラー");

  t.equal(normalize(999999), 999999);
  t.equal(normalize(null), null);
  t.equal(normalize(false), false);
  t.equal(normalize("不明"), "不明", "正規化できないケース");
  t.end();
});

test("ex/standardAreaCode#validate", function (t) {
  t.doesNotThrow(() => validate("011002"), "有効な地方公共団体コード（6桁）");
  t.throws(() => validate("01100"), "5桁コード");
  t.throws(() => validate("01100-2"), "区切りあり");
  t.throws(() => validate(1), "文字列でない");
  t.throws(() => validate("011003"), "チェックデジットエラー");
  t.end();
});

test("ex/standardAreaCode#STATLOD.csv", function (t) {
  const data = require("fs")
    .readFileSync(`${__dirname}/STATLOD.csv`, "UTF-8")
    .trim()
    .split("\n")
    .filter((a) => a.match(/^[0-9]{6}$/));
  t.ok(
    undefined ===
      data.find((x) => {
        try {
          validate(x);
          return false;
        } catch (e) {
          return true;
        }
      }),
    "全コードが valid であること"
  );
  t.equal(
    data.find((x) => {
      return x !== normalize(parseInt(x));
    }),
    undefined,
    "Integer code を normalize で復元できること"
  );
  t.equal(
    data.find((x) => {
      return x !== normalize(x.substring(0, 5));
    }),
    undefined,
    "チェックデジットを除いた文字列を normalize で復元できること"
  );
  t.end();
});
