const test = require("tape");
const { normalize, validate } = require("../lib/ex/spaceSeparatedZenkakuKana.js");

test("ex/spaceSeparatedZenkakuKana#normalize", function (t) {
  t.equal(normalize("ヤマダ ハナコ"), "ヤマダ ハナコ");
  t.equal(normalize("ヤマダハナコ"), "ヤマダハナコ");
  t.equal(normalize(""), "");
  t.equal(normalize("ヤマダ    ハナコ"), "ヤマダ ハナコ");
  t.equal(normalize("ヤマダ　ハナコ"), "ヤマダ ハナコ");
  t.equal(normalize("やまだ　はなこ"), "ヤマダ ハナコ");
  t.equal(normalize("ﾔﾏﾀﾞ ﾊﾅｺ"), "ヤマダ ハナコ");
  t.equal(normalize("ヤマタ\u3099　ハナコ"), "ヤマダ ハナコ");
  t.equal(normalize("やまた\u3099　はなこ"), "ヤマダ ハナコ");
  t.equal(normalize("ﾔﾏﾀ\u3099 ﾊﾅｺ"), "ヤマダ ハナコ");
  t.equal(normalize(0), "0");
  t.equal(normalize(null), null);
  t.equal(normalize(true), true);
  t.equal(normalize(false), false);
  t.end();
});

test("ex/spaceSeparatedZenkakuKana#validate", function (t) {
  t.doesNotThrow(() => validate("ヤマダ ハナコ"));
  t.doesNotThrow(() => validate("ヤマダハナコ"));
  t.doesNotThrow(() => validate(""));
  t.throws(() => validate(0));
  t.throws(() => validate("ヤマダ　ハナコ"));
  t.throws(() => validate("やまだ　はなこ"));
  t.throws(() => validate("ﾔﾏﾀﾞ ﾊﾅｺ"));
  t.throws(() => validate("ヤマタ\u3099　ハナコ"));
  t.throws(() => validate("やまた\u3099　はなこ"));
  t.throws(() => validate("ﾔﾏﾀ\u3099 ﾊﾅｺ"));
  t.end();
});
