const test = require("tape");
const { normalize, validate } = require("../lib/ex/spaceSeparatedString.js");

test("ex/spaceSeparatedString#normalize", function (t) {
  t.equal(normalize("パウロ 太郎"), "パウロ 太郎");
  t.equal(normalize("パウロ太郎"), "パウロ太郎");
  t.equal(normalize(""), "");
  t.equal(normalize("パウロ    太郎"), "パウロ 太郎");
  t.equal(normalize("パウロ　太郎"), "パウロ 太郎");
  t.equal(normalize("ぱうろ　太郎"), "ぱうろ 太郎");
  t.equal(normalize("ﾊﾟｳﾛ 太郎"), "パウロ 太郎");
  t.equal(normalize("ハ\u309aウロ　太郎"), "パウロ 太郎");
  t.equal(normalize("は\u309aうろ　太郎"), "ぱうろ 太郎");
  t.equal(normalize("ﾊ\u309aｳﾛ 太郎"), "パウロ 太郎");
  t.equal(normalize(0), "0");
  t.equal(normalize(null), null);
  t.equal(normalize(true), true);
  t.equal(normalize(false), false);
  t.end();
});

test("ex/spaceSeparatedString#validate", function (t) {
  t.doesNotThrow(() => validate("パウロ 太郎"));
  t.doesNotThrow(() => validate("パウロ太郎"));
  t.doesNotThrow(() => validate("ぱうろ 太郎"));
  t.doesNotThrow(() => validate(""));
  t.throws(() => validate(0));
  t.throws(() => validate("パウロ　太郎"));
  t.throws(() => validate("ﾊﾟｳﾛ 太郎"));
  t.throws(() => validate("ハ\u309aウロ　太郎"));
  t.throws(() => validate("は\u309aうろ　太郎"));
  t.throws(() => validate("ﾊ\u309aｳﾛ ﾊﾅｺ"));
  t.end();
});
