const test = require("tape");
const { normalize, validate } = require("../lib/ex/socialMedia.js");

test("ex/socialMedia#normalize", function (t) {
  t.equal(normalize("Instagram: xxx"), "Instagram: xxx");
  t.equal(normalize("Instagram:xxx"), "Instagram: xxx");
  t.equal(normalize("Instagram : xxx"), "Instagram: xxx");
  t.equal(normalize(""), "");
  t.equal(normalize("Instagram"), "Instagram");
  t.equal(normalize(":xxx"), ":xxx");

  t.equal(normalize(0), 0);
  t.equal(normalize(null), null);
  t.equal(normalize(true), true);
  t.equal(normalize(false), false);
  t.end();
});

test("ex/socialMedia#validate", function (t) {
  t.doesNotThrow(() => validate("Instagram: xxx"));
  t.doesNotThrow(() => validate("Instagram:xxx"));
  t.doesNotThrow(() => validate("Instagram : xxx"));
  t.doesNotThrow(() => validate(""), "空文字列");
  t.throws(() => validate(0), "文字列以外");
  t.throws(() => validate("Instagram"), "コロンがない");
  t.throws(() => validate(":username"), "サービス名がない");
  t.throws(() => validate("Instagram:"), "ユーザ名がない");
  t.end();
});
