const test = require("tape");
const { normalize, validate } = require("../lib/ex/semicolonSeparatedString.js");

test("ex/semicolonSeparatedString#normalize", function (t) {
  t.equal(normalize("きおい市;イベント;花火"), "きおい市;イベント;花火");
  t.equal(normalize("きおい市"), "きおい市");
  t.equal(normalize(""), "");
  t.equal(normalize("きおい市；イベント；花火"), "きおい市;イベント;花火");
  t.equal(normalize("きおい市;;イベント;;花火"), "きおい市;イベント;花火");
  t.equal(normalize("きおい市;イベント;花火;"), "きおい市;イベント;花火");
  t.equal(normalize("きおい市;  イベント;  花火"), "きおい市;イベント;花火");
  t.equal(normalize("きおい市;ｲﾍﾞﾝﾄ;花火"), "きおい市;イベント;花火");
  t.equal(normalize("きおい市;ｲﾍ\u3099ﾝﾄ;花火"), "きおい市;イベント;花火");
  t.equal(normalize("きおい市;イヘ\u3099ント;花火"), "きおい市;イベント;花火");
  t.equal(normalize(0), "0");
  t.equal(normalize(null), null);
  t.equal(normalize(true), true);
  t.equal(normalize(false), false);
  t.end();
});

test("ex/semicolonSeparatedString#validate", function (t) {
  t.doesNotThrow(() => validate("きおい市;イベント;花火"));
  t.doesNotThrow(() => validate("きおい市"));
  t.doesNotThrow(() => validate(""));
  t.throws(() => validate(0));
  t.throws(() => validate("きおい市；イベント；花火"));
  t.throws(() => validate("きおい市;;イベント;;花火"));
  t.throws(() => validate("きおい市;イベント;花火;"));
  t.throws(() => validate("きおい市;ｲﾍﾞﾝﾄ;花火"));
  t.throws(() => validate("きおい市;ｲﾍ\u3099ﾝﾄ;花火"));
  t.throws(() => validate("きおい市;イヘ\u3099ント;花火"));
  t.end();
});
