const test = require("tape");
const { normalize, validate } = require("../lib/ex/prefectureCode.js");

test("ex/prefectureCode#normalize", function (t) {
  t.equal(normalize("01"), "01");
  t.equal(normalize("1"), "01");
  t.equal(normalize(1), "01");
  t.equal(normalize("０１"), "01");
  t.equal(normalize("１"), "01");
  t.equal(normalize("01:北海道"), "01");
  t.equal(normalize("1:北海道"), "01");

  t.equal(normalize("010006"), "01");
  t.equal(normalize("01000"), "01");

  t.equal(normalize("49"), "49");
  t.equal(normalize(49), 49);
  t.equal(normalize(null), null);
  t.equal(normalize(false), false);
  t.equal(normalize("不明"), "不明", "正規化できないケース");
  t.end();
});

test("ex/prefectureCode#validate", function (t) {
  t.doesNotThrow(() => validate("01"), "有効な都道府県コード");
  t.throws(() => validate("010006"), "有効な地方公共団体コード（6桁）");
  t.throws(() => validate("01000"), "JISX0401+000（5桁）");
  t.throws(() => validate(1), "文字列でない");
  t.throws(() => validate("48"), "範囲外");
  t.end();
});
