const test = require("tape");
const { normalize, validate } = require("../lib/ex/phone.js");

test("ex/phone#normalize", function (t) {
  // 国内固定電話
  t.equal(normalize("(03)4477-6775"), "03-4477-6775");
  t.equal(normalize("0344776775"), "03-4477-6775");
  t.equal(normalize("0352352111"), "03-5235-2111");
  t.equal(normalize("０３５２３５２１１１"), "03-5235-2111");
  t.equal(normalize("〇三五二三五二一一一"), "03-5235-2111");

  t.equal(normalize("080-1234-1234"), "080-1234-1234");
  t.equal(normalize("08012341234"), "080-1234-1234");

  // 異常系
  t.equal(normalize("080-1234-1234-1234-1234"), "080-1234-1234-1234-1234");
  t.equal(normalize("abcd"), "abcd");
  t.equal(normalize("+abcd"), "+abcd");

  // 国際電話
  t.equal(normalize("+81 3-5253-2111"), "+81 3 5253 2111");
  t.equal(normalize("+81(3)-5253-2111"), "+81 3 5253 2111");
  t.equal(normalize("＋８１（３）ー５２５３ー２１１１"), "+81 3 5253 2111");
  t.equal(normalize("＋８１（３）ー５２５３ー２１１１"), "+81 3 5253 2111");

  // 内線番号
  t.equal(normalize("+81 3 3501 1511 ext. 2831"), "+81 3 3501 1511 ext. 2831");
  t.equal(normalize("03-4477-6775 ext. 2831"), "03-4477-6775 ext. 2831");
  t.equal(normalize("03-4477-6775 Ext. 2831"), "03-4477-6775 ext. 2831");

  t.equal(normalize(0), 0);
  t.equal(normalize(null), null);
  t.equal(normalize(true), true);
  t.equal(normalize(false), false);

  t.end();
});

test("ex/phone#validate", function (t) {
  // 国内固定電話
  t.doesNotThrow(() => validate("03-4477-6775"));
  t.throws(() => validate("0344776775"));
  t.throws(() => validate("(03)4477-6775"));

  // 携帯電話
  t.doesNotThrow(() => validate("080-1234-1234"));
  t.throws(() => validate("08012341234"));
  t.throws(() => validate("(080)12341234"));

  // 国際電話
  t.doesNotThrow(() => validate("+81 3 4477 6775"));
  t.throws(() => validate("+81344776775"));
  t.throws(() => validate("+81(03)4477-6775"));

  // 内線番号
  t.doesNotThrow(() => validate("+81 3 3501 1511 ext. 2831"));
  t.doesNotThrow(() => validate("03-4477-6775 ext. 2831"));
  t.throws(() => validate("+81 3 3501 1511 Ext. 2831"));
  t.throws(() => validate("03-4477-6775 Ext. 2831"));

  // 異常系
  t.throws(() => validate("+81344776775"));
  t.throws(() => validate("+81(03)4477-6775"));
  t.throws(() => validate(0));

  t.end();
});
