const test = require("tape");
const { normalize, validate } = require("../lib/ex/number.js");

test("ex/number#normalize", function (t) {
  t.equal(normalize(1234), 1234);
  t.equal(normalize("1234"), 1234);
  t.equal(normalize("-1234"), -1234);
  t.equal(normalize("１２３４"), 1234);
  t.equal(normalize("-１２３４"), -1234);
  t.equal(normalize(0.1234), 0.1234);
  t.equal(normalize("0.1234"), 0.1234);
  t.equal(normalize("-0.1234"), -0.1234);
  t.equal(normalize("０．１２３４"), 0.1234);
  t.equal(normalize("-０．１２３４"), -0.1234);
  t.equal(normalize(null), null);
  t.equal(normalize(true), true);
  t.equal(normalize(false), false);
  t.equal(normalize("!@#$"), "!@#$");
  t.equal(normalize("不明"), "不明");
  t.end();
});

test("ex/number#validate", function (t) {
  t.doesNotThrow(() => validate(0));
  t.doesNotThrow(() => validate(1234));
  t.doesNotThrow(() => validate(-1234));
  t.doesNotThrow(() => validate(0.1234));
  t.doesNotThrow(() => validate(-0.1234));
  t.throws(() => validate("abcd"));
  t.throws(() => validate(NaN));
  t.throws(() => validate(null));
  t.throws(() => validate(false));
  t.throws(() => validate(true));
  t.end();
});
