const test = require("tape");
const { normalize, validate } = require("../lib/ex/monthDate.js");

test("ex/monthDate#normalize", function (t) {
  t.equal(normalize("0101"), "01-01", "正常系");
  t.equal(normalize("101"), "01-01", "ハイフン、接頭ゼロの省略");
  t.equal(normalize("1231"), "12-31", "正常系");
  t.equal(normalize(101), "01-01", "整数(3桁)");
  t.equal(normalize(1231), "12-31", "整数(4桁)");
  t.equal(normalize("12月31日"), "12-31", "半角+漢字");
  t.equal(normalize("1月1日"), "01-01", "半角+漢字");
  t.equal(normalize("１２月３１日"), "12-31", "全角+漢字");
  t.equal(normalize("１月１日"), "01-01", "全角+漢字");
  t.equal(normalize("13-01"), "13-01", "無効な月");
  t.equal(normalize("01-32"), "01-32", "無効な日");
  // 正規化ができない場合はソース文字列を返す
  t.equal(normalize(null), null);
  t.equal(normalize("不明"), "不明");
  t.end();
});

test("ex/monthDate#validate", function (t) {
  t.doesNotThrow(() => validate("12-01"));
  t.throws(() => validate(0));
  t.throws(() => validate(1201));
  t.throws(() => validate("１２－０１"));
  t.throws(() => validate("4月1日"));
  t.throws(() => validate("13-01"));
  t.throws(() => validate("01-32"));
  t.end();
});
