const test = require("tape");
const { normalize, validate } = require("../lib/ex/legalEntityNumber.js");

test("ex/legalEntityNumber#normalize", function (t) {
  t.equal(normalize("5010005007126"), "5010005007126", "有効な法人番号");
  t.equal(normalize("5 0100 0500 7126"), "5010005007126", "区切りあり");
  t.equal(normalize("５０１０００５００７１２６"), "5010005007126", "全角数字");
  t.equal(normalize("法人番号:5010005007126"), "5010005007126", "余計な情報");
  t.equal(normalize("法人番号:５ ０１００ ０５００ ７１２６"), "5010005007126", "複合");
  t.equal(normalize("不明"), "不明", "正規化できないケース");
  t.end();
});

test("ex/legalEntityNumber#validate", function (t) {
  t.doesNotThrow(() => validate("5010005007126"), "有効な法人番号");
  t.throws(() => validate(5010005007126), "文字列でない");
  t.throws(() => validate("5 0100 0500 7126"), "区切りあり");
  t.throws(() => validate("５０１０００５００７１２６"), "全角数字");
  t.throws(() => validate("法人番号:5010005007126"), "余計な文字列");
  t.throws(() => validate("501000500712"), "文字数の不足");
  t.throws(() => validate("50100050071266"), "文字数の過剰");
  t.throws(() => validate("4010005007126"), "チェックデジットの不正");
  t.end();
});
