const test = require("tape");
const { normalize, validate } = require("../lib/ex/languageCode.js");

test("ex/languageCode#normalize", function (t) {
  t.equal(normalize("ja;en"), "ja;en", "有効な言語コードの列挙");
  t.equal(normalize("ja"), "ja", "有効な単体言語コード");
  t.equal(normalize("JA;EN"), "ja;en", "有効な言語コードの列挙(UpperCase)");
  t.equal(normalize("JA"), "ja", "有効な単体言語コード(UpperCase)");
  t.equal(normalize(" ja ; en "), "ja;en", "余計な空白");
  t.equal(normalize("ｊａ；ｅｎ"), "ja;en", "全角文字列");
  t.equal(normalize("ＪＡ；ＥＮ"), "ja;en", "全角文字列(UpperCase)");
  t.equal(normalize(""), "", "空白");
  t.equal(normalize("不明"), "不明", "正規化できないケース");
  t.equal(normalize("jpn;usa"), "jpn;usa", "文字数正規化できないケース");
  t.equal(normalize("jp-ja;us-en"), "jp-ja;us-en", "正規化できないケース");
  t.end();
});

test("ex/languageCode#validate", function (t) {
  t.doesNotThrow(() => validate("ja;en"), "有効な言語コードの列挙");
  t.doesNotThrow(() => validate("ja"), "有効な単体言語コード");
  t.doesNotThrow(() => validate(""), "空白");
  t.throws(() => validate(0), "文字列でない");
  t.throws(() => validate("ja;en;"), "末尾のセミコロン");
  t.throws(() => validate("JA;EN"), "小文字でない");
  t.throws(() => validate("ja en"), "セミコロン以外の区切り");
  t.throws(() => validate("ja；en"), "全角セミコロン");
  t.end();
});
