const test = require("tape");
const { normalize, validate } = require("../lib/ex/hankakuNumeric.js");

test("ex/hankakuNumeric#normalize", function (t) {
  t.equal(normalize("1234"), "1234");
  t.equal(normalize("１２３４"), "1234");
  t.equal(normalize(1234), "1234");
  t.equal(normalize(null), null);
  t.equal(normalize(true), true);
  t.equal(normalize(false), false);
  t.equal(normalize("!@#$"), "!@#$");
  t.equal(normalize("不明"), "不明");
  t.end();
});

test("ex/hankakuNumeric#validate", function (t) {
  t.doesNotThrow(() => validate("1234"));
  t.throws(() => validate(0));
  t.throws(() => validate("abcd"));
  t.throws(() => validate("１２３４"));
  t.end();
});
