const test = require("tape");
const { normalize, validate } = require("../lib/ex/hankaku.js");

test("ex/hankaku#normalize", function (t) {
  t.equal(normalize("abcdABCD1234!@#$%"), "abcdABCD1234!@#$%");
  t.equal(normalize("ａｂｃｄＡＢＣＤ１２３４！＠＃＄％"), "abcdABCD1234!@#$%");
  t.equal(normalize(1234), "1234");
  t.equal(normalize(null), null);
  t.equal(normalize(true), true);
  t.equal(normalize(false), false);
  t.equal(normalize("不明"), "不明");
  t.end();
});

test("ex/hankaku#validate", function (t) {
  t.doesNotThrow(() => validate("abcdABCD1234!@#$%"));
  t.throws(() => validate(0));
  t.throws(() => validate("ａｂｃｄＡＢＣＤ１２３４！＠＃＄％"));
  t.end();
});
