const test = require("tape");
const { normalize, validate } = require("../lib/ex/epsg.js");

test("ex/epsg#normalize", function (t) {
  t.equal(normalize("EPSG:3857"), "EPSG:3857");
  t.equal(normalize("epsg:3857"), "EPSG:3857");
  t.equal(normalize(3857), "EPSG:3857");
  t.equal(normalize("3857"), "EPSG:3857");
  t.equal(normalize("ｅｐｓｇ：３８５７"), "EPSG:3857");
  t.equal(normalize("ＥＰＳＧ：３８５７"), "EPSG:3857");
  t.equal(normalize(-1), -1);
  t.equal(normalize(null), null);
  t.equal(normalize("不明"), "不明");
  t.end();
});

test("ex/epsg#validate", function (t) {
  t.doesNotThrow(() => validate("EPSG:3857"));
  t.throws(() => validate(0));
  t.throws(() => validate("epsg:3857"));
  t.throws(() => validate("ｅｐｓｇ：３８５７"));
  t.throws(() => validate("ＥＰＳＧ：３８５７"));
  t.throws(() => validate("不明"));
  t.end();
});
