const test = require("tape");
const { normalize, validate } = require("../lib/ex/email.js");

test("ex/mail#normalize", function (t) {
  t.equal(normalize("john@example.org"), "john@example.org");
  t.equal(normalize("ｊｏｈｎ＠ｅｘａｍｐｌｅ．ｏｒｇ"), "john@example.org");
  t.equal(normalize("不明"), "不明");
  t.end();
});

test("ex/mail#validate", function (t) {
  t.doesNotThrow(() => validate("john@example.org"));
  t.throws(() => validate(0));
  t.throws(() => validate("ｊｏｈｎ＠ｅｘａｍｐｌｅ．ｏｒｇ"));
  t.throws(() => validate("不明"));
  t.end();
});
