const test = require("tape");
const { normalize, validate } = require("../lib/ex/day.js");

test("ex/day#normalize", function (t) {
  t.equal(normalize("月火水木金土日"), "月火水木金土日", "有効な曜日の列挙");
  t.equal(normalize("火水木金土日月"), "月火水木金土日", "月→日の順でない列挙");
  t.equal(normalize("月月火水木金金"), "月火水木金", "重複");
  t.equal(normalize("月曜日"), "月", "月曜日");
  t.equal(normalize("火曜日"), "火", "火曜日");
  t.equal(normalize("水曜日"), "水", "水曜日");
  t.equal(normalize("木曜日"), "木", "木曜日");
  t.equal(normalize("金曜日"), "金", "金曜日");
  t.equal(normalize("土曜日"), "土", "土曜日");
  t.equal(normalize("日曜日"), "日", "日曜日");
  t.equal(normalize("月曜"), "月", "月曜");
  t.equal(normalize("火曜"), "火", "火曜");
  t.equal(normalize("水曜"), "水", "水曜");
  t.equal(normalize("木曜"), "木", "木曜");
  t.equal(normalize("金曜"), "金", "金曜");
  t.equal(normalize("土曜"), "土", "土曜");
  t.equal(normalize("日曜"), "日", "日曜");
  t.equal(normalize("Mon"), "月", "Mon");
  t.equal(normalize("Tue"), "火", "Tue");
  t.equal(normalize("Wed"), "水", "Wed");
  t.equal(normalize("Thu"), "木", "Thu");
  t.equal(normalize("Fri"), "金", "Fri");
  t.equal(normalize("Sat"), "土", "Sat");
  t.equal(normalize("Sun"), "日", "Sun");
  t.equal(normalize("Monday"), "月", "Monday");
  t.equal(normalize("Tuesday"), "火", "Tuesday");
  t.equal(normalize("Wednesday"), "水", "Wednesday");
  t.equal(normalize("Thursday"), "木", "Thursday");
  t.equal(normalize("Friday"), "金", "Friday");
  t.equal(normalize("Saturday"), "土", "Saturday");
  t.equal(normalize("Sunday"), "日", "Sunday");
  t.equal(normalize(" "), "", "空白");
  t.equal(normalize("不明"), "不明", "正規化できないケース");
  t.end();
});

test("ex/day#validate", function (t) {
  t.doesNotThrow(() => validate("月火水木金土日"), "有効な曜日の列挙");
  t.doesNotThrow(() => validate(""), "空白");
  t.doesNotThrow(() => validate("月"), "月曜日");
  t.doesNotThrow(() => validate("火"), "火曜日");
  t.doesNotThrow(() => validate("水"), "水曜日");
  t.doesNotThrow(() => validate("木"), "木曜日");
  t.doesNotThrow(() => validate("金"), "金曜日");
  t.doesNotThrow(() => validate("土"), "土曜日");
  t.doesNotThrow(() => validate("日"), "日曜日");
  t.throws(() => validate(0), "文字列でない");
  t.throws(() => validate("火水木金土日月"), "月→日の順でない列挙");
  t.throws(() => validate("月月火水木金金"), "重複");
  t.throws(() => validate("日曜日"), "無効な文字列");
  t.throws(() => validate("月,火,水,木,金,土,日"), "区切り文字");
  t.end();
});
