const test = require("tape");
const { normalize, validate } = require("../lib/ex/dateTimeFormula.js");

test("ex/dateTimeFormula#normalize", function (t) {
  t.equal(normalize("99"), "99", "単体");
  t.equal(normalize("９９"), "99", "単体(全角)");
  t.equal(normalize("01,02,03"), "01,02,03", "列挙");
  t.equal(normalize("０１、０２、０３"), "01,02,03", "列挙(全角)");
  t.equal(normalize("03,02,01"), "01,02,03", "ソート");
  t.equal(normalize("09:00/12:00"), "09,10,11", "HH:MM/HH:MM形式の展開");
  t.equal(normalize("09:00/12:00 13:00/15:00"), "09,10,11,13,14", "HH:MM/HH:MM形式の列挙の展開");
  t.equal(
    normalize("09:00/12:00,13:00/15:00"),
    "09,10,11,13,14",
    "HH:MM/HH:MM形式の列挙の展開（カンマ区切り）"
  );
  t.equal(normalize("０９：００／１２：００"), "09,10,11", "HH:MM/HH:MM形式の展開（全角）");
  t.equal(normalize("09:00/12:00 13:00/15:00"), "09,10,11,13,14", "HH:MM/HH:MM形式の列挙の展開");
  t.equal(
    normalize("00:00/24:00"),
    "00,01,02,03,04,05,06,07,08,09,10,11,12,13,14,15,16,17,18,19,20,21,22,23",
    "24時間営業の展開"
  );

  t.equal(normalize("09:30/12:00"), "09,10,11", "開始時間がゼロ分でない場合");
  t.equal(normalize("09:00/12:30"), "09,10,11,12", "終了時間がゼロ分でない場合");
  t.equal(normalize("12:00/09:00"), "12:00/09:00", "開始時間と終了時間が逆転している");

  // 正規化ができない場合はソース文字列を返す
  t.equal(normalize("不明"), "不明");
  t.end();
});

test("ex/dateTimeFormula#validate", function (t) {
  t.doesNotThrow(() => validate("99"), "99:不明");
  t.doesNotThrow(() => validate("01,22"), "列挙");
  t.throws(() => validate(0), "文字列でない");
  t.throws(() => validate(""), "空文字列");
  t.throws(() => validate("24"), "範囲外文字列");
  t.throws(() => validate("９９"), "全角文字列");
  t.end();
});
