const test = require("tape");
const { normalize, validate } = require("../lib/ex/date.js");

test("ex/date#normalize", function (t) {
  t.equal(normalize("20190101"), "2019-01-01", '"20190101" を "2019-01-01" に正規化できること');
  t.equal(normalize("20191231"), "2019-12-31", '"20191231" を "2019-12-31" に正規化できること');
  t.equal(
    normalize("2019年12月31日"),
    "2019-12-31",
    '"2019年12月31日" を "2019-12-31" に正規化できること'
  );
  t.equal(
    normalize("2019年1月1日"),
    "2019-01-01",
    '"2019年1月1日" を "2019-01-01" に正規化できること'
  );
  t.equal(
    normalize("２０１９年１月１日"),
    "2019-01-01",
    '"２０１９年１月１日" を "2019-01-01" に正規化できること'
  );
  t.equal(
    normalize("２０１９年１２月３１日"),
    "2019-12-31",
    '"２０１９年１２月３１日" を "2019-12-31" に正規化できること'
  );
  t.equal(
    normalize("二〇一九年一月一日"),
    "2019-01-01",
    '"二〇一九年一月一日" を "2019-01-01" に正規化できること'
  );
  t.equal(
    normalize("二〇一九年十二月三十一日"),
    "2019-12-31",
    '"二〇一九年十二月三十一日" を "2019-12-31" に正規化できること'
  );
  t.equal(
    normalize("令和元年十二月三十一日"),
    "2019-12-31",
    '"令和元年十二月三十一日" を "2019-12-31" に正規化できること'
  );
  t.equal(
    normalize("令和元年一月一日"),
    "2019-01-01",
    '"令和元年一月一日" を "2019-01-01" に正規化できること'
  );
  t.equal(
    normalize("令和1年12月31日"),
    "2019-12-31",
    '"令和1年12月31日" を "2019-12-31" に正規化できること'
  );
  t.equal(
    normalize("令和1年1月1日"),
    "2019-01-01",
    '"令和1年1月1日" を "2019-01-01" に正規化できること'
  );
  t.equal(normalize("2019-12-31"), "2019-12-31", '"2019-12-31" を "2019-12-31" に正規化できること');
  t.equal(normalize("2019-01-01"), "2019-01-01", '"2019-01-01" を "2019-01-01" に正規化できること');
  t.equal(normalize("R1-12-31"), "2019-12-31", '"R1-12-31" を "2019-12-31" に正規化できること');
  t.equal(normalize("R1-01-01"), "2019-01-01", '"R1-01-01" を "2019-01-01" に正規化できること');
  t.equal(normalize("r1-12-31"), "2019-12-31", '"r1-12-31" を "2019-12-31" に正規化できること');
  t.equal(normalize("r1-01-01"), "2019-01-01", '"r1-01-01" を "2019-01-01" に正規化できること');
  t.equal(
    normalize("明治元年1月1日"),
    "1868-01-01",
    '"明治元年1月1日" を "1868-01-01" に正規化できること'
  );
  t.equal(
    normalize("大正元年1月1日"),
    "1912-01-01",
    '"大正元年1月1日" を "1912-01-01" に正規化できること'
  );
  t.equal(
    normalize("昭和元年1月1日"),
    "1926-01-01",
    '"昭和元年1月1日" を "1926-01-01" に正規化できること'
  );
  t.equal(
    normalize("平成元年1月1日"),
    "1989-01-01",
    '"平成元年1月1日" を "1989-01-01" に正規化できること'
  );
  t.equal(
    normalize("令和元年1月1日"),
    "2019-01-01",
    '"令和元年1月1日" を "2019-01-01" に正規化できること'
  );
  t.equal(
    normalize("明元年1月1日"),
    "1868-01-01",
    '"明元年1月1日" を "1868-01-01" に正規化できること'
  );
  t.equal(
    normalize("大元年1月1日"),
    "1912-01-01",
    '"大元年1月1日" を "1912-01-01" に正規化できること'
  );
  t.equal(
    normalize("昭元年1月1日"),
    "1926-01-01",
    '"昭元年1月1日" を "1926-01-01" に正規化できること'
  );
  t.equal(
    normalize("平元年1月1日"),
    "1989-01-01",
    '"平元年1月1日" を "1989-01-01" に正規化できること'
  );
  t.equal(
    normalize("令元年1月1日"),
    "2019-01-01",
    '"令元年1月1日" を "2019-01-01" に正規化できること'
  );
  t.equal(normalize("明1-1-1"), "1868-01-01", '"明1-1-1" を "1868-01-01" に正規化できること');
  t.equal(normalize("大1-1-1"), "1912-01-01", '"大1-1-1" を "1912-01-01" に正規化できること');
  t.equal(normalize("昭1-1-1"), "1926-01-01", '"昭1-1-1" を "1926-01-01" に正規化できること');
  t.equal(normalize("平1-1-1"), "1989-01-01", '"平1-1-1" を "1989-01-01" に正規化できること');
  t.equal(normalize("令1-1-1"), "2019-01-01", '"令1-1-1" を "2019-01-01" に正規化できること');
  t.equal(normalize("明元-1-1"), "1868-01-01", '"明元-1-1" を "1868-01-01" に正規化できること');
  t.equal(normalize("大元-1-1"), "1912-01-01", '"大元-1-1" を "1912-01-01" に正規化できること');
  t.equal(normalize("昭元-1-1"), "1926-01-01", '"昭元-1-1" を "1926-01-01" に正規化できること');
  t.equal(normalize("平元-1-1"), "1989-01-01", '"平元-1-1" を "1989-01-01" に正規化できること');
  t.equal(normalize("令元-1-1"), "2019-01-01", '"令元-1-1" を "2019-01-01" に正規化できること');
  t.equal(
    normalize("令和元ねん1がつ1にち"),
    "2019-01-01",
    '"令和元ねん1がつ1にち" を "2019-01-01" に正規化できること'
  );
  t.equal(
    normalize("平成三十一年四月三十日"),
    "2019-04-30",
    '"平成三十一年四月三十日" を "2019-04-30" に正規化できること'
  );
  t.equal(normalize("㍾1-1-1"), "1868-01-01", '"㍾1-1-1" を "1868-01-01" に正規化できること');
  t.equal(normalize("㍽1-1-1"), "1912-01-01", '"㍽1-1-1" を "1912-01-01" に正規化できること');
  t.equal(normalize("㍼1-1-1"), "1926-01-01", '"㍼1-1-1" を "1926-01-01" に正規化できること');
  t.equal(normalize("㍻1-1-1"), "1989-01-01", '"㍻1-1-1" を "1989-01-01" に正規化できること');
  t.equal(normalize("㋿1-1-1"), "2019-01-01", '"㋿1-1-1" を "2019-01-01" に正規化できること');
  t.equal(normalize("令1-1-1"), "2019-01-01", '"令1-1-1" を "2019-01-01" に正規化できること');
  // 正規化ができない場合はソース文字列を返す
  t.equal(normalize("不明"), "不明", '"不明" を "不明" に正規化できること');
  t.end();
});

test("ex/date#validate", function (t) {
  t.doesNotThrow(() => validate("2024-01-01"), "yyyy-mm-dd は例外をスローしないこと");
  t.throws(() => validate(0), "数値の場合は例外をスローすること");
  t.throws(() => validate("2024-1-1"), "yyyy-m-d は例外をスローすること");
  t.throws(() => validate("２０２４－０１－０１"), "yyyy-mm-dd (全角) は例外をスローすること");
  t.end();
});
