const moji = require("moji");

function validate(a) {
  if (typeof a !== "string") throw Error("文字列ではありません");
  if (a.match(/[\uFF61-\uFF9F]/)) throw new Error("半角カナは使用できません");
  if (a.match(/[\u3099\u309a]/)) throw new Error("結合文字列は使用できません");
  if (!a.match(/^[ァ-ヴー]*$/)) throw new Error("全角カナだけが使用可能です");
  return true;
}

function normalize(a) {
  if (typeof a !== "string") return a;
  const s = moji(a.normalize("NFKC")).convert("HG", "KK").toString().replaceAll(/[\s]+/g, "");
  try {
    validate(s);
    return s;
  } catch (e) {}
  return a;
}
module.exports = { validate, normalize };
