//const phone = require("libphonenumber-js/max");
const phone = require("libphonenumber-js");

module.exports = {
  validate: function (s) {
    if (typeof s !== "string") throw new Error("文字列ではありません");
    //if (!s.match(/^[ -~]*$/)) throw new Error("半角文字だけが使用可能です");
    //return true;

    // libphonenumber-js 正規化形式でなければ NG とすべきだとすると
    // トライアンドエラーを前提とすることになるため
    // 半角文字だけであれば OK とするのが穏当ではないか

    const international = s.startsWith("+");
    let normalized;
    try {
      const parsed = phone.parsePhoneNumberWithError(s, { defaultCountry: "JP" });
      normalized = international ? parsed.formatInternational() : parsed.formatNational();
    } catch (e) {
      throw new Error(`'${s}' は libphonenumber-js で正規化できませんでした`);
    }
    if (normalized !== s)
      throw new Error(
        `'${s}' のかわりに libphonenumber-js で正規化された電話番号 '${normalized}' を使用してください`
      );
    return true;
  },
  normalize: function (s) {
    if (typeof s !== "string") return s;
    const src =
      "〇一二三四五六七八九０１２３４５６７８９" +
      "（）[]［］{}｛｝【】『』「」〈〉《》＋ー‐－~～、，";
    const dst = "01234567890123456789" + "()()()()()()()()()()+-----,,";

    let n = s.normalize("NFKC");
    for (let i = 0; i < src.length; i++) n = n.replaceAll(src.charAt(i), dst.charAt(i));
    const international = n.startsWith("+");
    try {
      const parsed = phone.parsePhoneNumberWithError(n, { defaultCountry: "JP" });
      const normalized = international ? parsed.formatInternational() : parsed.formatNational();
      return normalized;
    } catch (e) {
      return s;
    }
  },
};
