/* 仕様書準拠 (20241125)
const def = {
  0: "不明(調査済み不明)",
  1: "無",
  2: "有",
  9: "非公開",
};
*/

// デジタル庁
const def = {
  0: "無",
  1: "有",
  2: "非公開",
  9: "不明",
};

function validate(a) {
  if (typeof a !== "string") throw Error("文字列ではありません");
  if (def[a] === undefined)
    throw new Error(
      "有効な値は以下のいずれかです: " +
        Object.entries(def)
          .map(([k, v]) => `${k}(${v})`)
          .join(", ")
    );
  return true;
}
function normalize(a) {
  if (typeof a === "number") {
    if (def[a] !== undefined) return a.toString();
    return a;
  }
  if (typeof a !== "string") return a;
  const s = a.normalize("NFKC").replace(/[^0-9]/g, "");
  try {
    validate(s);
    return s;
  } catch (e) {}
  return a;
}

module.exports = { validate, normalize };
