const def = {
  101: "国の機関",
  201: "地方公共団体",
  301: "株式会社",
  302: "有限会社",
  303: "合名会社",
  304: "合資会社",
  305: "合同会社",
  399: "その他の設立登記法人",
  401: "外国会社等",
  499: "その他",
};
function validate(a) {
  if (typeof a !== "string") throw Error("文字列ではありません");
  if (def[a] === undefined)
    throw new Error(
      "有効な値は以下のいずれかです: " +
        Object.entries(def)
          .map(([k, v]) => `${k}(${v})`)
          .join(", ")
    );
  return true;
}
function normalize(a) {
  if (typeof a === "number") {
    if (def[a] !== undefined) return a.toString();
    return a;
  }
  if (typeof a !== "string") return a;
  const s = a.normalize("NFKC").replace(/[^0-9]/g, "");
  try {
    validate(s);
    return s;
  } catch (e) {}
  return a;
}

module.exports = { validate, normalize };
