const iso3166 = require("./iso3166.js");

function validate(a) {
  if (typeof a !== "string") throw Error("文字列ではありません");
  if (!a.match(/^[A-Z]{3}$/))
    throw new Error("ISO-3166-1-alpha3 (半角大文字アルファベット3文字) を指定してください");
  if (iso3166.find((x) => x.includes(a))) return true;
  throw new Error("コードリストに登録されていないコードです");
}
function normalize(a) {
  if (typeof a !== "string") return a;
  const s = a
    .normalize("NFKC")
    .toUpperCase()
    .replace(/[^A-Z]/g, "");
  const x = iso3166.find((x) => x.includes(s));
  if (x) return x[1];
  return a;
}

module.exports = { validate, normalize };
