const moji = require("moji");

function validate(a) {
  if (typeof a !== "string") throw Error("文字列ではありません");
  if (a.match(/[\uFF61-\uFF9F]/)) throw new Error("半角カナは使用できません");
  if (a.match(/[\u3041-\u3096]/)) throw new Error("全角ひらがなは使用できません");
  if (a.match(/[\u3099\u309a]/)) throw new Error("結合文字列は使用できません");
  return true;
}

function normalize(a) {
  if (typeof a === "number") return normalize(a.toString());
  if (typeof a !== "string") return a;
  return moji(a.normalize("NFKC")).convert("HG", "KK").toString();
}
module.exports = { validate, normalize };
