function validate(a) {
  if (typeof a !== "string") throw Error("文字列ではありません");
  if (a.match(/[Ａ-Ｚａ-ｚ０-９]/)) throw new Error("全角英数字は使用できません");
  if (a.match(/[　]/)) throw new Error("全角スペースは使用できません");
  return true;
}

function normalize(a) {
  if (typeof a === "number") return normalize(a.toString());
  if (typeof a !== "string") return a;
  return a.normalize("NFKC");
}
module.exports = { validate, normalize };
