function checkDigit(s) {
  const d = s.split("").map((b) => parseInt(b));
  const sum = d[0] * 6 + d[1] * 5 + d[2] * 4 + d[3] * 3 + d[4] * 2;
  const mod = sum % 11;
  return ((11 - mod) % 10).toString();
}

function validate(a) {
  if (typeof a !== "string") throw new Error("文字列ではありません");
  if (!a.match(/^[0-9]{6}$/)) throw new Error("地方公共団体コードは6桁の数値で指定してください");
  if (!a.endsWith(checkDigit(a))) throw new Error("チェックデジットが不正です");
  return true;
}
function normalize(a) {
  if (typeof a === "number") {
    const n = a.toString().padStart(6, "0");
    try {
      validate(n);
      return n;
    } catch (e) {}
    return a;
  }
  if (typeof a !== "string") return a;

  let n = a.normalize("NFKC").replace(/[^0-9]/g, "");
  switch (n.length) {
    case 6:
      break;
    case 5:
      n = n + checkDigit(n);
      break;
    default:
      return a;
  }
  try {
    validate(n);
    return n;
  } catch (e) {}
  return a;
}

module.exports = { validate, normalize };
