function validate(a) {
  if (typeof a !== "string") throw Error("文字列ではありません");
  if (a.match(/[\uFF61-\uFF9F]/)) throw new Error("半角カナは使用できません");
  if (a.match(/[\u3099\u309a]/)) throw new Error("結合文字列は使用できません");
  if (a.split(" ").find((b) => b.match(/[\s]/)))
    throw Error("半角スペース以外の空白区切り文字が使用されています");

  return true;
}

function normalize(a) {
  if (typeof a === "number") return normalize(a.toString());
  if (typeof a !== "string") return a;
  return a.normalize("NFKC").trim().split(/[\s]+/).join(" ");
}
module.exports = { validate, normalize };
