function validate(a) {
  if (typeof a !== "string") throw Error("文字列ではありません");
  if (a.length === 0) return true;
  if (!a.match(/^[^:]+:.+$/))
    throw new Error("SNS の書式は「サービス名称: ユニークID」です（例:「Instagram: xxx」）");
  return true;
}

function normalize(a) {
  if (typeof a !== "string") return a;
  const b = a.normalize("NFKC").trim();
  if (b.length === 0) return b;

  const g = /^([^:]+):(.+)$/.exec(b);
  if (g) return g[1].trim() + ": " + g[2].trim();

  return a;
}
module.exports = { validate, normalize };
