function validate(a) {
  if (typeof a !== "string") throw Error("文字列ではありません");
  if (a.match(/[\uFF61-\uFF9F]/)) throw new Error("半角カナは使用できません");
  if (a.match(/[\u3099\u309a]/)) throw new Error("結合文字列は使用できません");
  if (a.split(";").find((b) => b.match(/[\s；]/)))
    throw Error("半角セミコロン以外の区切り文字(空白・全角セミコロン)が使用されています");
  if (a.includes(";;")) throw Error("連続する半角セミコロンが使用されています");
  if (a.endsWith(";")) throw Error("末尾の半角セミコロンは不要です");

  return true;
}

function normalize(a) {
  if (typeof a === "number") return normalize(a.toString());
  if (typeof a !== "string") return a;
  return a
    .normalize("NFKC")
    .trim()
    .split(/[\s;；]+/)
    .filter((b) => b.length > 0)
    .join(";");
}
module.exports = { validate, normalize };
