function validate(a) {
  if (typeof a !== "string") throw new Error("文字列ではありません");
  if (a.match(/^[0-9][0-9]$/)) {
    const n = parseInt(a);
    if (1 <= n && n <= 47) return true;
  }
  throw new Error("都道府県コードは 01～47 のいずれかの値です");
}
function normalize(a) {
  if (typeof a === "number") {
    const n = a.toString().padStart(2, "0");
    try {
      validate(n);
      return n;
    } catch (e) {}
    return a;
  }
  if (typeof a !== "string") return a;
  let s = a
    .normalize("NFKC")
    .replace(/[^0-9]/g, "")
    .padStart(2, "0")
    .substring(0, 2);
  try {
    validate(s);
    return s;
  } catch (e) {}
  return a;
}

module.exports = { validate, normalize };
