function validate(a) {
  if (typeof a !== "string") throw Error("文字列ではありません");
  const g = /^([0-9]{2})-([0-9]{2})$/.exec(a);
  if (!g) throw new Error("mm-dd 形式で指定してください");
  const m = parseInt(g[1]);
  const d = parseInt(g[2]);
  if (m < 1 || 12 < m) throw new Error("mm-dd 形式の mm は 01～12 のいずれかを指定してください");
  if (d < 1 || 31 < d) throw new Error("mm-dd 形式の dd は 01～31 のいずれかを指定してください");
  return true;
}
function normalize(a) {
  if (typeof a === "number") return normalize(a.toString());
  if (typeof a !== "string") return a;

  if (a.match(/^[0-9]+$/)) {
    const n = parseInt(a);
    const m = Math.floor(n / 100);
    const d = n % 100;
    return normalize(m + "-" + d);
  }

  const tokens = a
    .normalize("NFKC")
    .split(/[^0-9]+/)
    .filter((a) => a.match(/^[0-9]+$/))
    .map((a) => parseInt(a));
  if (tokens.length !== 2) return a;
  const s = tokens[0].toString().padStart(2, "0") + "-" + tokens[1].toString().padStart(2, "0");
  try {
    validate(s);
    return s;
  } catch (e) {}
  return a;
}

module.exports = { validate, normalize };
