function validate(a) {
  if (typeof a !== "string") throw Error("文字列ではありません");
  if (!a.match(/^[0-9]{13}$/)) throw new Error("法人番号は13桁数字です");

  const n = a.split("").map((b) => parseInt(b));
  const s1 = n[1] + n[3] + n[5] + n[7] + n[9] + n[11];
  const s2 = n[2] + n[4] + n[6] + n[8] + n[10] + n[12];
  const cd = 9 - ((s1 * 2 + s2) % 9);
  if (n[0] !== cd) throw new Error("法人番号のチェックデジットが不正です");
  return true;
}
function normalize(a) {
  const x = a.normalize("NFKC").replace(/[^0-9]/g, "");
  try {
    validate(x);
    return x;
  } catch (e) {}
  return a;
}

module.exports = { validate, normalize };
