function validate(a) {
  if (typeof a !== "string") throw new Error("文字列ではありません");
  if (a === "") return true;
  if (a.match(/^(?:[a-z]{2})(?:;[a-z]{2})*$/)) return true;
  throw new Error(
    "ISO639-1言語コードをセミコロン区切りで列挙したもの(例:「ja;en」)を指定してください"
  );
}
function normalize(a) {
  const s = a
    .normalize("NFKC")
    .toLowerCase()
    .replace(/[^a-z;]/g, "");

  if (a.trim().length > 0 && s.length === 0) return a;
  try {
    validate(s);
    return s;
  } catch (e) {
    return a;
  }
}

module.exports = { validate, normalize };
