function validate(a) {
  if (typeof a !== "string") throw Error("文字列ではありません");
  if (!a.match(/^[0-9]*$/)) throw new Error("半角数字だけが使用可能です");
  return true;
}
function normalize(a) {
  if (typeof a === "number") return normalize(a.toString());
  if (typeof a !== "string") return a;
  const s = a.normalize("NFKC");
  try {
    validate(s);
    return s;
  } catch (e) {}
  return a;
}
module.exports = { validate, normalize };
