function validate(a) {
  if (typeof a !== "string") throw new Error("文字列ではありません");
  if (!a.match(/^EPSG:[0-9]+$/)) throw new Error("「EPSG:6668」のような書式で記述してください");
  return true;
}
function normalize(a) {
  if (typeof a === "number") {
    if (Number.isInteger(a) && a > 0) return normalize("EPSG:" + a);
    return a;
  }
  if (typeof a !== "string") return a;
  if (a.match(/^[0-9]+$/)) return normalize("EPSG:" + a);

  const s = a
    .normalize("NFKC")
    .toUpperCase()
    .replace(/[^EPSG:0-9]/g, "");
  try {
    validate(s);
    return s;
  } catch (e) {}
  return a;
}

module.exports = { validate, normalize };
