function validate(a) {
  if (typeof a !== "string") throw Error("文字列ではありません");
  if (!a.match(/^月?火?水?木?金?土?日?$/))
    throw new Error("「月火水木金」のような文字列を指定してください");
  return true;
}

const alias = {
  月: ["月曜日", "月曜", "Monday", "Mon"],
  火: ["火曜日", "火曜", "Tuesday", "Tue"],
  水: ["水曜日", "水曜", "Wednesday", "Wed"],
  木: ["木曜日", "木曜", "Thursday", "Thu"],
  金: ["金曜日", "金曜", "Friday", "Fri"],
  土: ["土曜日", "土曜", "Saturday", "Sat"],
  日: ["日曜日", "日曜", "Sunday", "Sun"],
};

function normalize(a) {
  let s = a.normalize("NFKC").toUpperCase();
  for (const [to, froms] of Object.entries(alias))
    for (const from of froms) s = s.replaceAll(from.toUpperCase(), to);
  const t = "月火水木金土日"
    .split("")
    .map((x) => (s.includes(x) ? x : ""))
    .join("");
  if (a.trim().length > 0 && t.length === 0) return a;
  return t;
}
module.exports = { validate, normalize };
