const code = {
  "00": "00:00/01:00",
  "01": "01:00/02:00",
  "02": "02:00/03:00",
  "03": "03:00/04:00",
  "04": "04:00/05:00",
  "05": "05:00/06:00",
  "06": "06:00/07:00",
  "07": "07:00/08:00",
  "08": "08:00/09:00",
  "09": "09:00/10:00",
  10: "10:00/11:00",
  11: "11:00/12:00",
  12: "12:00/13:00",
  13: "13:00/14:00",
  14: "14:00/15:00",
  15: "15:00/16:00",
  16: "16:00/17:00",
  17: "17:00/18:00",
  18: "18:00/19:00",
  19: "19:00/20:00",
  20: "20:00/21:00",
  21: "21:00/22:00",
  22: "22:00/23:00",
  23: "23:00/24:00",
  99: "不明・未定",
};

function validate(a) {
  if (typeof a !== "string") throw Error("文字列ではありません");
  if (a.trim().length === 0)
    throw Error("空文字列は使用できません (「99:不明・未定」を推奨します)");

  if (a.split(",").find((x) => code[x] === undefined))
    throw Error(
      "「441_コアデータパーツ_日付時刻」の時間帯コード(数字2文字 00-23,99)をカンマ区切りで列挙したものを指定してください"
    );
}
function normalize(a) {
  const tokens = a.normalize("NFKC").split(/[^0-9\/:]+/);
  const answer = new Set();
  for (const token of tokens) {
    if (code[token]) answer.add(token);
    else {
      const re = /^([0-9]{2}):([0-9]{2})\/([0-9]{2}):([0-9]{2})/.exec(token);
      if (re) {
        const from = parseInt(re[1]);
        const to = parseInt(re[3]) + (re[4] === "00" ? -1 : 0);
        if (from <= to) for (let i = from; i <= to; i++) answer.add(i.toString().padStart(2, "0"));
      }
    }
  }
  const s = Array.from(answer).sort().join(",");
  try {
    validate(s);
    return s;
  } catch (e) {}
  return a;
}

module.exports = { validate, normalize };
