function validate(s) {
  if (typeof s !== "string") throw new Error("文字列ではありません");
  if (s.match(/^[0-9]{4}\-[01][0-9]\-[0123][0-9]$/)) return true;
  throw Error(`ISO8601 (yyyy-mm-dd) 形式ではありません`);
}
function normalize(s) {
  const src = [
    ["九十九", "九十八", "九十七", "九十六", "九十五", "九十四", "九十三", "九十二", "九十一"],
    ["八十九", "八十八", "八十七", "八十六", "八十五", "八十四", "八十三", "八十二", "八十一"],
    ["七十九", "七十八", "七十七", "七十六", "七十五", "七十四", "七十三", "七十二", "七十一"],
    ["六十九", "六十八", "六十七", "六十六", "六十五", "六十四", "六十三", "六十二", "六十一"],
    ["五十九", "五十八", "五十七", "五十六", "五十五", "五十四", "五十三", "五十二", "五十一"],
    ["四十九", "四十八", "四十七", "四十六", "四十五", "四十四", "四十三", "四十二", "四十一"],
    ["三十九", "三十八", "三十七", "三十六", "三十五", "三十四", "三十三", "三十二", "三十一"],
    ["二十九", "二十八", "二十七", "二十六", "二十五", "二十四", "二十三", "二十二", "二十一"],
    ["九十", "八十", "七十", "六十", "五十", "四十", "三十", "二十"],
    ["十九", "十八", "十七", "十六", "十五", "十四", "十三", "十二", "十一"],
    ["十", "九", "八", "七", "六", "五", "四", "三", "二", "一", "〇", "元"],
    ["９", "８", "７", "６", "５", "４", "３", "２", "１", "０"],
  ].flat();
  const dst = [
    ["99", "98", "97", "96", "95", "94", "93", "92", "91"],
    ["89", "88", "87", "86", "85", "84", "83", "82", "81"],
    ["79", "78", "77", "76", "75", "74", "73", "72", "71"],
    ["69", "68", "67", "66", "65", "64", "63", "62", "61"],
    ["59", "58", "57", "56", "55", "54", "53", "52", "51"],
    ["49", "48", "47", "46", "45", "44", "43", "42", "41"],
    ["39", "38", "37", "36", "35", "34", "33", "32", "31"],
    ["29", "28", "27", "26", "25", "24", "23", "22", "21"],
    ["90", "80", "70", "60", "50", "40", "30", "20"],
    ["19", "18", "17", "16", "15", "14", "13", "12", "11"],
    ["10", "9", "8", "7", "6", "5", "4", "3", "2", "1", "0", "1"],
    ["9", "8", "7", "6", "5", "4", "3", "2", "1", "0"],
  ].flat();

  let n = s.trim();
  src.forEach((k, i) => (n = n.replaceAll(k, dst[i])));

  const date = (function (n) {
    let r;
    if ((r = /^(\d{4})(\d{2})(\d{2})$/.exec(n)))
      return new Date(parseInt(r[1]), parseInt(r[2]) - 1, parseInt(r[3]));
    if ((r = /^(\d+)\D+(\d+)\D+(\d+)\D*$/.exec(n)))
      return new Date(parseInt(r[1]), parseInt(r[2]) - 1, parseInt(r[3]));
    if ((r = /^(令和|[令RrＲｒ㋿\uF9A8])(\d+)\D+(\d+)\D+(\d+)\D*$/.exec(n)))
      return new Date(2018 + parseInt(r[2]), parseInt(r[3]) - 1, parseInt(r[4]));
    if ((r = /^(平成|[平HhＨｈ㍻])(\d+)\D+(\d+)\D+(\d+)\D*$/.exec(n)))
      return new Date(1988 + parseInt(r[2]), parseInt(r[3]) - 1, parseInt(r[4]));
    if ((r = /^(昭和|[昭SsＳｓ㍼])(\d+)\D+(\d+)\D+(\d+)\D*$/.exec(n)))
      return new Date(1925 + parseInt(r[2]), parseInt(r[3]) - 1, parseInt(r[4]));
    if ((r = /^(大正|[大TtＴｔ㍽])(\d+)\D+(\d+)\D+(\d+)\D*$/.exec(n)))
      return new Date(1911 + parseInt(r[2]), parseInt(r[3]) - 1, parseInt(r[4]));
    if ((r = /^(明治|[明MmＭｍ㍾])(\d+)\D+(\d+)\D+(\d+)\D*$/.exec(n)))
      return new Date(1867 + parseInt(r[2]), parseInt(r[3]) - 1, parseInt(r[4]));
    return null;
  })(n);

  if (date)
    return [
      date.getFullYear().toString(),
      (date.getMonth() + 1).toString().padStart(2, "0"),
      date.getDate().toString().padStart(2, "0"),
    ].join("-");

  return s;
}

module.exports = { validate, normalize };
